//------------------------------------------------------------------------------
// File: client_savealerts.cs
// This file is used to save and load the asserts on the client.  The functions
// here are synched with the server-side alert saving and loading functions.
//
// Copyright Sandlot Games, 2007
// Author: Michael Felice
//------------------------------------------------------------------------------

// this function is called from the server when the client-side alert
// system needs to be saved to a file (this is synched with the server,
// so once the client is done saving the alerts, the server is
// notified so it can continue saving)
function clientCmdAlertSaveToFile()
{
   // save the alert index locations
   slgSaveInt($AlertOpenIdx);
   for (%index = 0; %index < $ALERT_COUNT; %index++)
   {
      %value = $AlertIdx[%index];
      slgSaveString(%value);
      
      if (%value !$= "")
      {
         %text = alertGetBtnText(%value);
         slgSaveString(%text.stateUp);
      }
   }
   
   // save the locked button list
   slgSaveInt($AlertBtnLockCount);
   for (%index = 0; %index < $AlertBtnLockCount; %index++)
   {
      %button = $AlertBtnLock[%index];
      slgSaveInt(%button.alertType);
      slgSaveInt(%button.alertCount);
      slgSaveInt(%button.alertSel);
      slgSaveString(%button.position);
   }
   
   // save the moving button list
   slgSaveInt($AlertBtnMoveCount);
   for (%index = 0; %index < $AlertBtnMoveCount; %index++)
   {
      %button = $AlertBtnMove[%index];
      slgSaveInt(%button.alertType);
      slgSaveInt(%button.alertCount);
      slgSaveInt(%button.alertSel);
      slgSaveString(%button.position);
   }
   
   // save the alert messages
   slgSaveInt($AlertMsgCount);
   for (%index = 0; %index < $AlertMsgCount; %index++)
   {
      %message = $AlertMsg[%index];
      slgSaveString(%message.textUp);
      slgSaveString(%message.position);
      
      %totalTime = %message.destroytimer.getTotalTime();
      %elapsedTime = %message.destroytimer.getElapsedTime();
      slgSaveFloat(%totalTime);
      slgSaveFloat(%elapsedTime);
   }
   
   SaveMenus();
   QuestGuiSaveToFile();
   QuestHudSaveToFile();
   HudMessageSaveToFile();
   
   // MGR:
   // I believe this should be placed here. Not sure where else to put it
   saveAmbientSounds();
   
   //commandToServer('AlertSaveToFileDone');
   TaskButtonSaveToFile();
}

// this function is called from the server when the client-side alert
// system needs to be loaded from a file (this is synched with the server,
// so once the client is done loading the alerts, the server is
// notified so it can continue loading)
function clientCmdAlertLoadFromFile()
{
   alertDestroySystem();
   alertCreateUpdateTimer();
   
   // load the alert index locations
   $AlertOpenIdx = slgLoadInt();
   for (%index = 0; %index < $ALERT_COUNT; %index++)
   {
      %value = slgLoadString();
      $AlertIdx[%index] = %value;
      
      if (%value !$= "")
      {
         %text = alertGetBtnText(%value);
         %text.stateUp = slgLoadString();
      }
   }
   
   // load the locked button list
   $AlertBtnLockCount = slgLoadInt();
   for (%index = 0; %index < $AlertBtnLockCount; %index++)
   {
      %type = slgLoadInt();
      %count = slgLoadInt();
      %sel = slgLoadInt();
      %position = slgLoadString();
      
      %button = alertCreateBtn(%type, %count);
      %button.sel = %sel;
      %button.position = %position;
      %button.input = true;
      %button.lock = true;
      %button.stateUp = "assets/client/ui/icons/alertbtn.png";
      $AlertBtnLock[%index] = %button;
   }
   
   // load the moving button list
   $AlertBtnMoveCount = slgLoadInt();
   for (%index = 0; %index < $AlertBtnMoveCount; %index++)
   {
      %type = slgLoadInt();
      %count = slgLoadInt();
      %sel = slgLoadInt();
      %position = slgLoadString();
      
      %button = alertCreateBtn(%type, %count);
      %button.sel = %sel;
      %button.position = %position;
      $AlertBtnMove[%index] = %button;
   }
   
   // load the alert messages
   $AlertMsgCount = slgLoadInt();
   for (%index = 0; %index < $AlertMsgCount; %index++)
   {
      %text = slgLoadString();
      %position = slgLoadString();
      
      // set up the new message that will be filled with the
      // loaded alert data
      %message = new SLTextImage()
      {
         textUp = %text;
         visible = true;
         input = false;
         applyAlphaToText = true;
         stateUp = AlertMsgTemp.stateUp;
         profile = AlertMsgTemp.profile;
         horizSizing = "relative";
         vertSizing = "relative";
         position = %position;
         extent = AlertMsgTemp.extent;
      };
      $AlertMsg[%index] = %message;
      AlertHudMsg.addGuiControl(%message);
      
      %totalTime = slgLoadFloat();
      %elapsedTime = slgLoadFloat();
      
      // set up the new timer that will tell the alert message
      // when it needs to be popped from the message queue
      %timer = new SLTimer()
      {
         time = %totalTime;
      };
      %timer.setElapsedTime(%elapsedTime);
      %timer.notifyOnFire(alertPopMsg);
      %message.destroytimer = %timer;
   }
   
   LoadMenus($LoadResources);
   QuestGuiLoadFromFile();
   QuestHudLoadFromFile();
   HudMessageLoadFromFile();

   // MGR:
   // I believe this should be placed here. Not sure where else to put it
   loadAmbientSounds();
   
   //commandToServer('AlertLoadFromFileDone');
   TaskButtonLoadFromFile();
}
